/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.cotton.gui.widget;

import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import io.github.cottonmc.cotton.gui.impl.client.TextAlignment;
import io.github.cottonmc.cotton.gui.impl.client.TextStyleCapturer;
import io.github.cottonmc.cotton.gui.impl.mixin.client.ScreenAccessor;
import io.github.cottonmc.cotton.gui.widget.WWidget;
import io.github.cottonmc.cotton.gui.widget.data.HorizontalAlignment;
import io.github.cottonmc.cotton.gui.widget.data.InputResult;
import io.github.cottonmc.cotton.gui.widget.data.VerticalAlignment;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.Nullable;

public class WLabel
extends WWidget {
    protected class_2561 text;
    protected HorizontalAlignment horizontalAlignment = HorizontalAlignment.LEFT;
    protected VerticalAlignment verticalAlignment = VerticalAlignment.TOP;
    protected int color;
    protected int darkmodeColor;
    protected boolean drawShadows;
    public static final int DEFAULT_TEXT_COLOR = -12566464;
    public static final int DEFAULT_DARKMODE_TEXT_COLOR = -4408132;

    public WLabel(class_2561 text, int color) {
        this.text = text;
        this.color = color;
        this.darkmodeColor = color == -12566464 ? -4408132 : color;
    }

    public WLabel(class_2561 text) {
        this(text, -12566464);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
        int yOffset = TextAlignment.getTextOffsetY(this.verticalAlignment, this.height, 1);
        if (this.getDrawShadows()) {
            ScreenDrawing.drawStringWithShadow(context, this.text.method_30937(), this.horizontalAlignment, x, y + yOffset, this.getWidth(), this.shouldRenderInDarkMode() ? this.darkmodeColor : this.color);
        } else {
            ScreenDrawing.drawString(context, this.text.method_30937(), this.horizontalAlignment, x, y + yOffset, this.getWidth(), this.shouldRenderInDarkMode() ? this.darkmodeColor : this.color);
        }
        class_2583 hoveredTextStyle = this.getTextStyleAt(mouseX, mouseY);
        ScreenDrawing.drawTextHover(context, hoveredTextStyle, x + mouseX, y + mouseY);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public InputResult onClick(class_11909 click, boolean doubled) {
        class_2583 hoveredTextStyle = this.getTextStyleAt((int)click.comp_4798(), (int)click.comp_4799());
        if (hoveredTextStyle != null) {
            class_310 client = class_310.method_1551();
            class_437 screen = client.field_1755;
            if (hoveredTextStyle.method_10970() != null) {
                ScreenAccessor.libgui$handleClickEvent(hoveredTextStyle.method_10970(), client, screen);
                return InputResult.of(true);
            }
        }
        return InputResult.IGNORED;
    }

    @Environment(value=EnvType.CLIENT)
    @Nullable
    public class_2583 getTextStyleAt(int x, int y) {
        if (this.isWithinBounds(x, y)) {
            int offsetX = TextAlignment.getTextOffsetX(this.horizontalAlignment, this.width, this.text.method_30937());
            int offsetY = TextAlignment.getTextOffsetY(this.verticalAlignment, this.height, 1);
            class_327 textRenderer = class_310.method_1551().field_1772;
            TextStyleCapturer styleCapturer = new TextStyleCapturer(textRenderer, x - offsetX, y - offsetY);
            styleCapturer.method_75763(0, 0, this.text);
            return styleCapturer.method_75777();
        }
        return null;
    }

    @Override
    public boolean canResize() {
        return true;
    }

    @Override
    public void setSize(int x, int y) {
        super.setSize(x, Math.max(8, y));
    }

    public int getDarkmodeColor() {
        return this.darkmodeColor;
    }

    public WLabel setDarkmodeColor(int color) {
        this.darkmodeColor = color;
        return this;
    }

    public WLabel disableDarkmode() {
        this.darkmodeColor = this.color;
        return this;
    }

    public int getColor() {
        return this.color;
    }

    public WLabel setColor(int color) {
        this.color = color;
        return this;
    }

    public WLabel setColor(int color, int darkmodeColor) {
        this.color = color;
        this.darkmodeColor = darkmodeColor;
        return this;
    }

    public boolean getDrawShadows() {
        return this.drawShadows;
    }

    public WLabel setDrawShadows(boolean drawShadows) {
        this.drawShadows = drawShadows;
        return this;
    }

    public class_2561 getText() {
        return this.text;
    }

    public WLabel setText(class_2561 text) {
        this.text = text;
        return this;
    }

    public HorizontalAlignment getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public WLabel setHorizontalAlignment(HorizontalAlignment align) {
        this.horizontalAlignment = align;
        return this;
    }

    public VerticalAlignment getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public WLabel setVerticalAlignment(VerticalAlignment align) {
        this.verticalAlignment = align;
        return this;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void addNarrations(class_6382 builder) {
        builder.method_37034(class_6381.field_33788, this.text);
    }
}

