package io.github.cottonmc.cotton.gui;

import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3917;
import net.minecraft.class_5630;

/**
 * A {@link SyncedGuiDescription} for an {@linkplain class_1799 item stack}
 * in an {@linkplain net.minecraft.class_1263 inventory}.
 *
 * <p>The owning item is represented with a {@link class_5630}, which can be
 * an item in an entity's inventory or a block's container, or any other reference
 * to an item stack.
 *
 * <p>If the owning item stack changes in any way, the screen closes by default (see {@link #method_7597(class_1657)}).
 *
 * @since 7.0.0
 */
public class ItemSyncedGuiDescription extends SyncedGuiDescription {
	/**
	 * A reference to the owning item stack of this GUI.
	 */
	protected final class_5630 owner;

	/**
	 * The initial item stack of this GUI. This stack must <strong>not</strong> be mutated!
	 */
	protected final class_1799 ownerStack;

	/**
	 * Constructs an {@code ItemSyncedGuiDescription}.
	 *
	 * @param type            the screen handler type
	 * @param syncId          the sync ID
	 * @param playerInventory the inventory of the player viewing this GUI description
	 * @param owner           a reference to the owning item stack of this GUI description
	 */
	public ItemSyncedGuiDescription(class_3917<?> type, int syncId, class_1661 playerInventory, class_5630 owner) {
		super(type, syncId, playerInventory);
		this.owner = Objects.requireNonNull(owner, "Owner cannot be null");
		this.ownerStack = owner.method_32327().method_7972();
	}

	/**
	 * {@inheritDoc}
	 *
	 * <p>The default implementation for {@code ItemSyncedGuiDescription} returns {@code true} if and only if
	 * the {@linkplain #owner current owning item stack} is {@linkplain class_1799#method_7973 fully equal}
	 * to the {@linkplain #ownerStack original owner}.
	 *
	 * <p>If the item NBT is intended to change, subclasses should override this method to only check
	 * the item and the count. Those subclasses should also take care to respond properly
	 * to any NBT changes in the owning item stack.
	 */
	@Override
	public boolean method_7597(class_1657 entity) {
		return class_1799.method_7973(ownerStack, owner.method_32327());
	}
}
