package io.github.cottonmc.cotton.gui.widget;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_332;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import com.google.common.collect.ImmutableList;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * A widget that displays an item or a list of items.
 *
 * @since 1.8.0
 */
public class WItem extends WWidget {
	private List<class_1799> items;
	private int duration = 25;
	private int ticks = 0;
	private int current = 0;

	public WItem(List<class_1799> items) {
		setItems(items);
	}

	public WItem(class_6862<? extends class_1935> tag) {
		this(getRenderStacks(tag));
	}

	public WItem(class_1799 stack) {
		this(Collections.singletonList(stack));
	}

	@Override
	public boolean canResize() {
		return true;
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void tick() {
		if (ticks++ >= duration) {
			ticks = 0;
			current = (current + 1) % items.size();
		}
	}

	@Environment(EnvType.CLIENT)
	@Override
	public void paint(class_332 context, int x, int y, int mouseX, int mouseY) {
		context.method_51445(items.get(current), x + getWidth() / 2 - 8, y + getHeight() / 2 - 8);
	}

	/**
	 * Returns the animation duration of this {@code WItem}.
	 *
	 * <p>Defaults to 25 screen ticks.
	 */
	public int getDuration() {
		return duration;
	}

	public WItem setDuration(int duration) {
		this.duration = duration;
		return this;
	}

	public List<class_1799> getItems() {
		return items;
	}

	/**
	 * Sets the item list of this {@code WItem} and resets the animation state.
	 *
	 * @param items the new item list
	 * @return this instance
	 */
	public WItem setItems(List<class_1799> items) {
		Objects.requireNonNull(items, "stacks == null!");
		if (items.isEmpty()) throw new IllegalArgumentException("The stack list is empty!");

		this.items = items;

		// Reset the state
		current = 0;
		ticks = 0;

		return this;
	}

	/**
	 * Gets the default stacks ({@link class_1792#method_7854()} ()}) of each item in a tag.
	 */
	@SuppressWarnings("unchecked")
	private static List<class_1799> getRenderStacks(class_6862<? extends class_1935> tag) {
		class_2378<class_1935> registry = (class_2378<class_1935>) class_7923.field_41167.method_63535(tag.comp_326().method_29177());
		ImmutableList.Builder<class_1799> builder = ImmutableList.builder();

		for (class_6880<class_1935> item : registry.method_40286((class_6862<class_1935>) tag)) {
			builder.add(item.comp_349().method_8389().method_7854());
		}

		return builder.build();
	}
}
