package io.github.cottonmc.cotton.gui.impl;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5481;
import io.github.cottonmc.cotton.gui.client.ScreenDrawing;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;

import java.util.ArrayList;
import java.util.List;

/**
 * A "logger" that renders its messages on the screen in dev envs.
 */
public final class VisualLogger {
	private static final List<class_2561> WARNINGS = new ArrayList<>();

	private final Logger logger;
	private final Class<?> clazz;

	public VisualLogger(Class<?> clazz) {
		logger = LogManager.getLogger(clazz);
		this.clazz = clazz;
	}

	public void error(String message, Object... params) {
		log(message, params, Level.ERROR, class_124.field_1061);
	}

	public void warn(String message, Object... params) {
		log(message, params, Level.WARN, class_124.field_1065);
	}

	private void log(String message, Object[] params, Level level, class_124 formatting) {
		logger.log(level, message, params);

		if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
			var text = class_2561.method_43470(clazz.getSimpleName() + '/');
			text.method_10852(class_2561.method_43470(level.name()).method_27692(formatting));
			text.method_10852(class_2561.method_43470(": " + ParameterizedMessage.format(message, params)));

			WARNINGS.add(text);
		}
	}

	@Environment(EnvType.CLIENT)
	public static void render(class_332 context) {
		var client = class_310.method_1551();
		var textRenderer = client.field_1772;
		int width = client.method_22683().method_4486();
		List<class_5481> lines = new ArrayList<>();

		for (class_2561 warning : WARNINGS) {
			lines.addAll(textRenderer.method_1728(warning, width));
		}

		int fontHeight = textRenderer.field_2000;
		int y = 0;

		for (var line : lines) {
			ScreenDrawing.coloredRect(context, 2, 2 + y, textRenderer.method_30880(line), fontHeight, 0x88_000000);
			ScreenDrawing.drawString(context, line, 2, 2 + y, 0xFF_FFFFFF);
			y += fontHeight;
		}
	}

	public static void reset() {
		WARNINGS.clear();
	}
}
