package io.github.cottonmc.cotton.gui;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import io.github.cottonmc.cotton.gui.impl.VisualLogger;
import io.github.cottonmc.cotton.gui.widget.WItemSlot;

import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;

public class ValidatedSlot extends class_1735 {
	/**
	 * The default {@linkplain #setInputFilter(Predicate) item filter} that allows all items.
	 *
	 * @since 5.1.1
	 */
	public static final Predicate<class_1799> DEFAULT_ITEM_FILTER = stack -> true;
	private static final VisualLogger LOGGER = new VisualLogger(ValidatedSlot.class);
	private final int slotNumber;
	private boolean insertingAllowed = true;
	private boolean takingAllowed = true;
	private Predicate<class_1799> inputFilter = DEFAULT_ITEM_FILTER;
	private Predicate<class_1799> outputFilter = DEFAULT_ITEM_FILTER;
	protected final Multimap<WItemSlot, WItemSlot.ChangeListener> listeners = HashMultimap.create();
	private boolean visible = true;

	public ValidatedSlot(class_1263 inventory, int index, int x, int y) {
		super(inventory, index, x, y);
		if (inventory==null) throw new IllegalArgumentException("Can't make an itemslot from a null inventory!");
		this.slotNumber = index;
	}
	
	@Override
	public boolean method_7680(class_1799 stack) {
		return insertingAllowed && field_7871.method_5437(slotNumber, stack) && inputFilter.test(stack);
	}
	
	@Override
	public boolean method_7674(class_1657 player) {
		return takingAllowed && field_7871.method_5443(player) && outputFilter.test(method_7677());
	}
	
	@Override
	public class_1799 method_7677() {
		if (field_7871==null) {
			LOGGER.warn("Prevented null-inventory from WItemSlot with slot #: {}", slotNumber);
			return class_1799.field_8037;
		}
		
		class_1799 result = super.method_7677();
		if (result==null) {
			LOGGER.warn("Prevented null-itemstack crash from: {}", field_7871.getClass().getCanonicalName());
			return class_1799.field_8037;
		}
		
		return result;
	}

	@Override
	public void method_7668() {
		listeners.forEach((slot, listener) -> listener.onStackChanged(slot, field_7871, getInventoryIndex(), method_7677()));
		super.method_7668();
	}

	/**
	 * Gets the index of this slot in its inventory.
	 *
	 * @return the inventory index
	 */
	public int getInventoryIndex() {
		return slotNumber;
	}

	/**
	 * Returns whether items can be inserted into this slot.
	 *
	 * @return true if items can be inserted, false otherwise
	 * @since 1.10.0
	 */
	public boolean isInsertingAllowed() {
		return insertingAllowed;
	}

	/**
	 * Sets whether inserting items into this slot is allowed.
	 *
	 * @param insertingAllowed true if items can be inserted, false otherwise
	 * @since 1.10.0
	 */
	public void setInsertingAllowed(boolean insertingAllowed) {
		this.insertingAllowed = insertingAllowed;
	}

	/**
	 * Returns whether items can be taken from this slot.
	 *
	 * @return true if items can be taken, false otherwise
	 * @since 1.10.0
	 */
	public boolean isTakingAllowed() {
		return takingAllowed;
	}

	/**
	 * Sets whether taking items from this slot is allowed.
	 *
	 * @param takingAllowed true if items can be taken, false otherwise
	 * @since 1.10.0
	 */
	public void setTakingAllowed(boolean takingAllowed) {
		this.takingAllowed = takingAllowed;
	}

	/**
	 * Gets the item stack input filter of this slot.
	 *
	 * @return the item input filter
	 * @since 8.1.0
	 */
	public Predicate<class_1799> getInputFilter() {
		return inputFilter;
	}

	/**
	 * Sets the item stack input filter of this slot.
	 *
	 * @param inputFilter the new item input filter
	 * @since 8.1.0
	 */
	public void setInputFilter(Predicate<class_1799> inputFilter) {
		this.inputFilter = inputFilter;
	}

	/**
	 * Gets the item stack output filter of this slot.
	 *
	 * @return the item output filter
	 * @since 8.1.0
	 */
	public Predicate<class_1799> getOutputFilter() {
		return outputFilter;
	}

	/**
	 * Sets the item stack output filter of this slot.
	 *
	 * @param outputFilter the new item output filter
	 * @since 8.1.0
	 */
	public void setOutputFilter(Predicate<class_1799> outputFilter) {
		this.outputFilter = outputFilter;
	}

	/**
	 * Adds a change listener to this slot.
	 * Does nothing if the listener is already registered.
	 *
	 * @param owner    the owner of this slot
	 * @param listener the listener
	 * @throws NullPointerException if either parameter is null
	 * @since 3.0.0
	 */
	public void addChangeListener(WItemSlot owner, WItemSlot.ChangeListener listener) {
		Objects.requireNonNull(owner, "owner");
		Objects.requireNonNull(listener, "listener");
		listeners.put(owner, listener);
	}

	@Override
	public boolean method_7682() {
		return isVisible();
	}

	/**
	 * Tests whether this slot is visible.
	 *
	 * @return true if this slot is visible, false otherwise
	 * @since 3.0.0
	 */
	public boolean isVisible() {
		return visible;
	}

	/**
	 * Sets whether this slot is visible.
	 *
	 * @param visible true if this slot if visible, false otherwise
	 * @since 3.0.0
	 */
	public void setVisible(boolean visible) {
		this.visible = visible;
	}
}
