package io.github.cottonmc.jankson;

import java.util.Collection;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import blue.endless.jankson.api.Marshaller;

public class BlockAndItemSerializers {
	public static class_2680 getBlockStatePrimitive(String blockIdString, Marshaller m) {
		Optional<class_2248> blockOpt = class_7923.field_41175.method_17966(class_2960.method_60654(blockIdString));
		if (blockOpt.isPresent()) {
			return blockOpt.get().method_9564();
		} else {
			return null;
		}
	}
	
	/**
	 * @param json A json object representing a BlockState
	 * @return the BlockState represented, or null if the object does not represent a valid BlockState.
	 */
	public static class_2680 getBlockState(JsonObject json, Marshaller m) {
		String blockIdString = json.get(String.class, "block");
		
		class_2248 block = class_7923.field_41175.method_17966(class_2960.method_60654(blockIdString)).orElse(null);
		if (block==null) return null;
		
		class_2680 state = block.method_9564();
		JsonObject stateObject = json.getObject("BlockStateTag");
		if (stateObject==null) stateObject = json;
		
		Collection<class_2769<?>> properties = state.method_28501();
		for(String key : stateObject.keySet()) {
			if (stateObject==json && (key.equals("BlockStateTag") || key.equals("block"))) continue;
			
			for(class_2769<?> property : properties) {
				if (property.method_11899().equals(key)) {
					String val = stateObject.get(String.class, key);
					state = withProperty(state, property, val);
					break;
				}
			}
		}
		
		return state;
	}
	
	public static JsonElement saveBlockState(class_2680 state, Marshaller m) {
		class_2680 defaultState = state.method_26204().method_9564();
		
		if (state.equals(defaultState)) {
			//Use a String for the blockID only
			return new JsonPrimitive( class_7923.field_41175.method_10221(state.method_26204()).toString() );
			
		} else {
			JsonObject result = new JsonObject();
			result.put("block", new JsonPrimitive( class_7923.field_41175.method_10221(state.method_26204()).toString() ));
			JsonObject stateObject = result;
			for(class_2769<?> property : state.method_28501()) {
				String key = property.method_11899();
				if (key.equals("block") || key.equals("BlockStateTag")) { //Certain dangerous keys mean we should partition off blockstate properties
					stateObject = new JsonObject();
					result.put("BlockStateTag", stateObject);
					break;
				}
			}
			
			for(class_2769<?> property : state.method_28501()) {
				if (state.method_11654(property).equals(defaultState.method_11654(property))) continue;
				String key = property.method_11899();
				String val = getProperty(state, property);
				stateObject.put(key, new JsonPrimitive(val));
			}
			
			return result;
		}
	}
	
	public static <T extends Comparable<T>> class_2680 withProperty(class_2680 state, class_2769<T> property, String stringValue) {
		Optional<T> val = property.method_11900(stringValue);
		if (val.isPresent()) {
			return state.method_11657(property, val.get());
		} else {
			return state;
		}
	}
	
	public static <T extends Comparable<T>> String getProperty(class_2680 state, class_2769<T> property) {
		return property.method_11901(state.method_11654(property));
	}
}
